import React from "react";
import { Dialog } from "@headlessui/react";

export default function PuzzleModal({ open, onClose, title, children }) {
  return (
    <Dialog
      open={open}
      onClose={onClose}
      className="fixed inset-0 z-50 flex items-center justify-center"
    >
      <div className="fixed inset-0 bg-black/60" aria-hidden />
      <Dialog.Panel className="bg-white/6 p-6 rounded-2xl w-full max-w-md">
        <Dialog.Title className="font-semibold text-lg">{title}</Dialog.Title>
        <div className="mt-3 text-white/80">{children}</div>
      </Dialog.Panel>
    </Dialog>
  );
}
